within AixLib.Utilities.Sensors;
model EnergyMeter
  "\"Integrates power [W] that is connected to input connector\""

  Modelica.Blocks.Interfaces.RealInput p(unit="W") annotation(Placement(transformation(origin={-60,0},    extent={{14,-14},
            {-14,14}},                                                                                                                     rotation = 180),
        iconTransformation(
        extent={{14,-14},{-14,14}},
        rotation=180,
        origin={-56,0})));
  Modelica.SIunits.Conversions.NonSIunits.Energy_kWh q_kWh;
  Modelica.SIunits.Energy q_joule(stateSelect = StateSelect.avoid, start = 0.0);
equation
  der(q_joule) = p;
  q_kWh = Modelica.SIunits.Conversions.to_kWh(q_joule);
  annotation (preferredView = "info", Icon(coordinateSystem(extent={{-60,-80},{
            60,80}}),                      graphics={  Rectangle(extent = {{-40, 66}, {46, -62}}, lineColor = {0, 0, 255}, fillColor = {95, 95, 95},
            fillPattern =                                                                                                   FillPattern.Solid), Rectangle(extent = {{-20, 38}, {30, 12}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255},
            fillPattern =                                                                                                   FillPattern.Solid), Line(points = {{4, 24}, {4, 14}, {4, 16}}, color = {0, 0, 0}), Line(points = {{14, 24}, {14, 14}, {14, 16}}, color = {0, 0, 0}), Line(points = {{24, 24}, {24, 14}, {24, 16}}, color = {0, 0, 0}), Line(points = {{-6, 24}, {-6, 14}, {-6, 16}}, color = {0, 0, 0}), Line(points = {{-14, 24}, {-14, 14}, {-14, 16}}, color = {0, 0, 0}), Line(points = {{-16, 30}, {28, 30}, {26, 30}}, color = {0, 0, 0}, thickness = 0.5), Line(points = {{0, 30}, {10, 30}, {10, 30}}, color = {255, 0, 0}, thickness = 0.5), Text(extent = {{-12, 24}, {-4, 14}}, lineColor = {0, 0, 0}, textString = "1"), Text(extent = {{16, 24}, {24, 14}}, lineColor = {0, 0, 0}, textString = "1"), Text(extent = {{6, 24}, {14, 14}}, lineColor = {0, 0, 0}, textString = "1"), Text(extent = {{-4, 24}, {4, 14}}, lineColor = {0, 0, 0}, textString = "1")}), Documentation(info="<html>
<p><b><span style=\"color: #008000;\">Overview</span></b> </p>
<p>Model of an energy meter (integration over time of the Real input connector [W]). </p>
<p><span style=\"font-size: 14pt;\">BE CAREFUL:</span> Model<b> might slow down the simulation speed</b> since unnecessaries state events might be triggered.</p><p>So please check prior whether it is worth to implement the meter.</p>
<p><b><span style=\"color: #008000;\">Level of Development</span></b> </p>
<p><img src=\"modelica://AixLib/Resources/Images/Stars/stars2.png\" alt=\"stars: 2 out of 5\"/> </p>
</html>",  revisions="<html>
 <ul>
 <li><i>October 11, 2016&nbsp;</i> by Philipp Mehrfeld:<br/>Removed two old models and combined to this one. Give input connector unit [W].</li>
 <li><i>October 15, 2013&nbsp;</i> by Ole Odendahl:<br/>Formatted documentation appropriately</li>
 <li>by Alexander Hoh:<br/>implemented</li>
 </ul>
 </html>"),
    Diagram(coordinateSystem(extent={{-60,-80},{60,80}})));
end EnergyMeter;
